import { View, Text, StyleSheet, Pressable } from 'react-native';
import React, { useEffect } from 'react';
import dpr from '../../../../Utilities/CustomStyleAttribute/dpr';
import ProgressiveImage from '../../../../../src/components/ProgressiveImage';
import { useDispatch } from 'react-redux';
import { useNavigation } from '@react-navigation/core';
import { BASE_API_URL_STG } from '@env';
import CustomRating from '../../../../Utilities/CustomRating/CustomRating';
import useLangTranslation from '../../../../../hooks/useLangTranslation';
import ProductItemOwnerSkeleton from '../../../../../src/skeletons/screens/home/ProductItemOwnerSkeleton';
import { queryResponse } from '../../../../../redux/slices/util/processResponse';
import { useState } from 'react';

const ItemOwner = ({ shop_alias, vendor_id }) => {
    const { trans } = useLangTranslation();
    const dispatch = useDispatch();
    const navigation = useNavigation();
    const [vendor, setVendor] = useState({});
    const [loading, setLoading] = useState(false);

    useEffect(() => {
        (async() => {
            if (vendor_id) {
                let URL = `${BASE_API_URL_STG}/vendor/${vendor_id}`;
                setLoading(true)
                try {
                    const res = await queryResponse(URL);
                    const { records, status } = res || {};
                    if (status?.code == 200) {
                        setVendor(records?.data);
                    }
                } catch (error) {} finally {
                    setLoading(false)
                }
            }
        })()
    }, [vendor_id]);

    const { name, rating, total_review, logo } = vendor || {};

    return (
        <View style={styles.container}>
            <View style={styles.subCont}>
                {loading ? (
                    <ProductItemOwnerSkeleton />
                ) : (
                    <>
                        <View>
                            <Text style={styles.soldBy}>
                                {trans('Sold By')}
                            </Text>
                            <Text
                                onPress={() => {
                                    navigation.navigate('Vendor', {
                                        shop_alias: shop_alias,
                                        vendor_id,
                                        vendor
                                    });
                                }}
                                style={styles.ownerName}
                            >
                                {name}
                            </Text>
                            <View style={styles.ratingCont}>
                                <CustomRating
                                    rating={rating == null ? 0 : rating}
                                    starSize={dpr(17)}
                                    readOnly={true}
                                />
                                <View style={styles.ratingCont}>
                                    <Text style={styles.ratingText}>
                                        {rating == null
                                            ? 0
                                            : Number(rating).toFixed(1)}
                                    </Text>
                                    <Text style={styles.soldBy}>
                                        (
                                        {total_review == 1
                                            ? trans("{{x}} Review", { x: total_review })
                                            : trans("{{y}} Reviews", { y: total_review })}
                                        )
                                    </Text>
                                </View>
                            </View>
                        </View>
                        <Pressable
                            onPress={() => {
                                navigation.navigate('Vendor', {
                                    shop_alias: shop_alias,
                                    vendor_id,
                                    vendor
                                });
                            }}
                        >
                            <ProgressiveImage
                                source={{ uri: logo }}
                                style={styles.img}
                            />
                        </Pressable>
                    </>
                )}
            </View>
        </View>
    );
};

export default ItemOwner;

const styles = StyleSheet.create({
    container: {
        backgroundColor: '#fff',
        paddingHorizontal: dpr(20),
        paddingBottom: dpr(20),
        borderTopWidth: 1,
        borderColor: '#DFDFDF',
    },
    subCont: {
        backgroundColor: '#2C2C2C',
        flexDirection: 'row',
        justifyContent: 'space-between',
        alignItems: 'center',
        borderRadius: 6,
        padding: dpr(18),
        marginTop: dpr(15),
    },
    img: {
        height: dpr(80),
        width: dpr(80),
    },
    soldBy: {
        fontFamily: 'Roboto_500Medium',
        fontSize: dpr(16),
        color: '#898989',
        textAlign: 'left'
    },
    ownerName: {
        fontFamily: 'DMSans_700Bold',
        fontSize: dpr(20),
        color: '#FFFFFF',
        marginVertical: dpr(6),
        textAlign: 'left'
    },
    ratingCont: {
        flexDirection: 'row',
        alignItems: 'center',
    },
    ratingText: {
        fontFamily: 'Roboto_500Medium',
        fontSize: dpr(16),
        color: '#FFFFFF',
        marginLeft: dpr(8),
        marginRight: dpr(5),
        textAlign: 'left'
    },
});
